$fn= 360;
//Tolerance
tol= 0.2;

//Box dimensions
length= 95;
width= 84;
height= 30;
thickness=3;

//PCB dimensions
PCB_L= 80;
PCB_W= 80;
PCB_H= 10; // Total height
PCB_T= 2; // PCB thickness
PCB_DH = 2; // Holding distance

//USB dimensions
USB_L = 11; //USB Length
USB_H = 9; //USB Height
PCB_W = 8; //USB Width

//Banana Jack dimensions
Jack_H = 6.35; //USB Height
Jack_L = 8.4; //USB Length
D=15;
DD=19.05;


difference(){
    cube([length,width,height],center=true);
    cube([length,width-thickness,height-thickness],center=true);
//Lock Holes
X= 2*((length/2)-length/2.3)-tol; 
Y= 2*((width/2)-width/10);
Z= height-(thickness*2)-tol;
for(k=[-1,1]){translate([k*((width-X)/2+thickness*1.2+tol),0,0])for(u=[-1,1]){translate([0,0,u*(Z+thickness)/2]){ 
difference(){
    rotate([0,90,90])cylinder(h=Y+2*tol,r=thickness,center=true);
    rotate([0,90,90])cylinder(h=Y-width/5-2*tol,r=thickness,center=true);}
        } 
        } 
        }

//Air vents
    for(i=[0:5:40]){
    translate([i,0,height/5])rotate(90,0,0) cube([length,2,height/2.5],center=true);
    }
    }
 
 //PCB mount rack   
translate([0,(width-thickness)/2,-(height-PCB_H)/3]){    
difference(){
    cube([length,PCB_DH,PCB_T*3],center=true);
    cube([length,PCB_DH,PCB_T+tol],center=true);
    }    
}

translate([0,-(width-thickness)/2,-(height-PCB_H)/3]){    
difference(){
    cube([length,PCB_DH,PCB_T*3],center=true);
    cube([length,PCB_DH,PCB_T+tol],center=true);
    }    
}

//Letters
translate([-length/5,-27,height/2])color("blue"){  
rotate (90) scale([2,length/40,0.5]) drawtext("DStat");  
}
translate([length/3,-10,height/2])color("blue"){  
rotate (90) scale([4,length/25,0.5]) drawtext("W");  
}
translate([length/5.5,0,height/2]) color("blue")
difference(){
    cylinder ( h=2, r= length/5,center=true); 
    cylinder ( h=2, r= length/5-0.5,center=true);
}


//USB Back
translate([(length+thickness),0,0]){
    rotate(90,0,0)
difference(){
    cube([width,thickness,height],center=true);
translate([-PCB_W/2,0,-(height-PCB_H)/3])
    cube([USB_L,thickness,USB_H],center=true);
}
X= 2*((length/2)-length/2.3)-tol; 
Y= 2*((width/2)-width/10);
Z= height-(thickness*2)-tol;
translate([-X/2,0,0]) 
{
color("black")difference(){
    cube([X,Y,Z+thickness-tol*2],center=true);
    cube([X,Y-width/5+tol,Z+thickness*2.2],center=true);
    cube([X,Y,Z-thickness],center=true);
    }
for(u=[-1,1]){translate([-X/4-tol*2,0,u*(Z+thickness)/2]){ 
difference(){
    rotate([0,90,90])cylinder(h=Y-tol,r=thickness-3*tol,center=true);
    rotate([0,90,90])cylinder(h=Y-width/5+tol,r=thickness,center=true);}
        }}
}
        }

    
//Front
translate([-length,0,0])rotate([0,180,0]){
    rotate(90,0,0)
difference(){
    cube([width,thickness,height],center=true);
for(i=[-(DD+D),-D,0,D,(DD+D)]){translate([i,0,2*thickness-(height-Jack_H)/2]){
    cube([Jack_L,thickness,Jack_H],center=true);    //for(u=[-1,1]){translate([0,0,u*Jack_H/4])rotate([90,0,0])cylinder(h=thickness*2,r=Jack_L/2, center=True);}
     
    }}
}//color("red")scale([thickness,width/60,height/40]) translate([-0.2,0,D/2+4])rotate (90)rotate([-90,0,180]){
    //translate([-(DD+D)+7,0,0])drawtext("R");
    //translate([-(D+1),0,0])drawtext("Rs");
    //translate([-2.5,0,0])drawtext("C");
    //translate([D-9,0,0])drawtext("Ws");
    //translate([D+7,0,0])drawtext("W");}

X= 2*((length/2)-length/2.3)-tol; 
Y= 2*((width/2)-width/10);
Z= height-(thickness*2)-tol;
translate([-X/2,0,0]) 
{
color("black")difference(){
    cube([X,Y,Z+thickness-tol*2],center=true);
    cube([X,Y-width/5+tol,Z+thickness*2.2],center=true);
    cube([X,Y,Z-thickness],center=true);
    }
for(u=[-1,1]){translate([-X/4-tol*2,0,u*(Z+thickness)/2]){ 
difference(){
    rotate([0,90,90])cylinder(h=Y-tol,r=thickness-3*tol,center=true);
    rotate([0,90,90])cylinder(h=Y-width/5+tol,r=thickness,center=true);}
        }}
}
        }

//Text Generator routine
module drawtext(text) {
	//Characters
	chars = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}";

	//Chracter table defining 5x7 characters
	//Adapted from: http://www.geocities.com/dinceraydin/djlcdsim/chartable.js
	char_table = [ [ 0, 0, 0, 0, 0, 0, 0],
                  [ 4, 0, 4, 4, 4, 4, 4],
                  [ 0, 0, 0, 0,10,10,10],
                  [10,10,31,10,31,10,10],
                  [ 4,30, 5,14,20,15, 4],
                  [ 3,19, 8, 4, 2,25,24],
                  [13,18,21, 8,20,18,12],
                  [ 0, 0, 0, 0, 8, 4,12],
                  [ 2, 4, 8, 8, 8, 4, 2],
                  [ 8, 4, 2, 2, 2, 4, 8],
                  [ 0, 4,21,14,21, 4, 0],
                  [ 0, 4, 4,31, 4, 4, 0],
                  [ 8, 4,12, 0, 0, 0, 0],
                  [ 0, 0, 0,31, 0, 0, 0],
                  [12,12, 0, 0, 0, 0, 0],
                  [ 0,16, 8, 4, 2, 1, 0],
                  [14,17,25,21,19,17,14],
                  [14, 4, 4, 4, 4,12, 4],
                  [31, 8, 4, 2, 1,17,14],
                  [14,17, 1, 2, 4, 2,31],
                  [ 2, 2,31,18,10, 6, 2],
                  [14,17, 1, 1,30,16,31],
                  [14,17,17,30,16, 8, 6],
                  [ 8, 8, 8, 4, 2, 1,31],
                  [14,17,17,14,17,17,14],
                  [12, 2, 1,15,17,17,14],
                  [ 0,12,12, 0,12,12, 0],
                  [ 8, 4,12, 0,12,12, 0],
                  [ 2, 4, 8,16, 8, 4, 2],
                  [ 0, 0,31, 0,31, 0, 0],
                  [16, 8, 4, 2, 4, 8,16],
                  [ 4, 0, 4, 2, 1,17,14],
                  [14,21,21,13, 1,17,14],
                  [17,17,31,17,17,17,14],
                  [30,17,17,30,17,17,30],
                  [14,17,16,16,16,17,14],
                  [30,17,17,17,17,17,30],
                  [31,16,16,30,16,16,31],
                  [16,16,16,30,16,16,31],
                  [15,17,17,23,16,17,14],
                  [17,17,17,31,17,17,17],
                  [14, 4, 4, 4, 4, 4,14],
                  [12,18, 2, 2, 2, 2, 7],
                  [17,18,20,24,20,18,17],
                  [31,16,16,16,16,16,16],
                  [17,17,17,21,21,27,17],
                  [17,17,19,21,25,17,17],
                  [14,17,17,17,17,17,14],
                  [16,16,16,30,17,17,30],
                  [13,18,21,17,17,17,14],
                  [17,18,20,30,17,17,30],
                  [30, 1, 1,14,16,16,15],
                  [ 4, 4, 4, 4, 4, 4,31],
                  [14,17,17,17,17,17,17],
                  [ 4,10,17,17,17,17,17],
                  [10,21,21,21,17,17,17],
                  [17,17,10, 4,10,17,17],
                  [ 4, 4, 4,10,17,17,17],
                  [31,16, 8, 4, 2, 1,31],
                  [14, 8, 8, 8, 8, 8,14],
                  [ 0, 1, 2, 4, 8,16, 0],
                  [14, 2, 2, 2, 2, 2,14],
                  [ 0, 0, 0, 0,17,10, 4],
                  [31, 0, 0, 0, 0, 0, 0],
                  [ 0, 0, 0, 0, 2, 4, 8],
                  [15,17,15, 1,14, 0, 0],
                  [30,17,17,25,22,16,16],
                  [14,17,16,16,14, 0, 0],
                  [15,17,17,19,13, 1, 1],
                  [14,16,31,17,14, 0, 0],
                  [ 8, 8, 8,28, 8, 9, 6],
                  [14, 1,15,17,15, 0, 0],
                  [17,17,17,25,22,16,16],
                  [14, 4, 4, 4,12, 0, 4],
                  [12,18, 2, 2, 2, 6, 2],
                  [18,20,24,20,18,16,16],
                  [14, 4, 4, 4, 4, 4,12],
                  [17,17,21,21,26, 0, 0],
                  [17,17,17,25,22, 0, 0],
                  [14,17,17,17,14, 0, 0],
                  [16,16,30,17,30, 0, 0],
                  [ 1, 1,15,19,13, 0, 0],
                  [16,16,16,25,22, 0, 0],
                  [30, 1,14,16,15, 0, 0],
                  [ 6, 9, 8, 8,28, 8, 8],
                  [13,19,17,17,17, 0, 0],
                  [ 4,10,17,17,17, 0, 0],
                  [10,21,21,17,17, 0, 0],
                  [17,10, 4,10,17, 0, 0],
                  [14, 1,15,17,17, 0, 0],
                  [31, 8, 4, 2,31, 0, 0],
                  [ 2, 4, 4, 8, 4, 4, 2],
                  [ 4, 4, 4, 4, 4, 4, 4],
                  [ 8, 4, 4, 2, 4, 4, 8] ];

	//Binary decode table
	dec_table = [ "00000", "00001", "00010", "00011", "00100", "00101",
  	            "00110", "00111", "01000", "01001", "01010", "01011",
  	            "01100", "01101", "01110", "01111", "10000", "10001",
  	            "10010", "10011", "10100", "10101", "10110", "10111",
	            "11000", "11001", "11010", "11011", "11100", "11101",
	            "11110", "11111" ];

	//Process string one character at a time
	for(itext = [0:len(text)-1]) {
		//Convert character to index
		ichar = search(text[itext],chars,1)[0];

        //Decode character - rows
        for(irow = [0:6]) {
            //Select value to draw from table
            val = dec_table[char_table[ichar][irow]];

            //Decode character - cols
            for(icol = [0:4]) {
                // Retrieve bit to draw
                bit = search(val[icol],"01",1)[0];

                if(bit) {
                    //Output cube
                    translate([icol + (6*itext), irow, 0])
                        cube([1.0001,1.0001,1]);
                }
            }
        }
	}
}