/**
 * \file
 *
 * \brief User board initialization template
 *
 */

#include <asf.h>
#include <board.h>
#include <conf_board.h>

void board_init(void)
{
	/* This function is meant to contain board-specific initialization code
	 * for, e.g., the I/O pins. The initialization can rely on application-
	 * specific board configuration, found in conf_board.h.
	 */
    
    ioport_set_pin_dir(PIN_EN, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_MS1, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_MS2, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_MS3, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_RST, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_SLP, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_STEP, IOPORT_DIR_OUTPUT);
    ioport_set_pin_dir(PIN_DIR, IOPORT_DIR_OUTPUT);

    ioport_set_pin_level(PIN_EN, 0);
    ioport_set_pin_level(PIN_RST, 1);
    ioport_set_pin_level(PIN_SLP, 1);
    ioport_set_pin_level(PIN_DIR, 1);
    
    // 8x microstepping
    ioport_set_pin_level(PIN_MS1, 1);
    ioport_set_pin_level(PIN_MS2, 1);
    ioport_set_pin_level(PIN_MS3, 0);
    
    ioport_set_pin_dir(PIN_ZMIN, IOPORT_DIR_INPUT);
    ioport_set_pin_sense_mode(PIN_ZMIN, IOPORT_SENSE_FALLING);
    
    #ifdef PIN_ZMIN_PULLUP_ENABLED
    ioport_set_pin_mode(PIN_ZMIN, IOPORT_MODE_PULLUP);
    #endif // PIN_ZMIN_PULLUP_ENABLED

}
