/*
 * main.c
 *
 * Created: 29/09/2012 2:13:52 AM
 *  Author: mdryden
 */ 

#include "asf.h"
#include <stdio.h>
#include <math.h>
#include <avr/io.h>
#include <avr/interrupt.h>

//Internal global variables
bool current_dir = 1;
uint16_t step_counter = 0;

//Internal function declarations
void single_step(void);
void multi_step(bool dir, uint16_t steps, uint16_t steps_per_s);

void single_step(void){
    static bool last_dir = 1;
    
    if (last_dir != current_dir) {
        ioport_set_pin_level(PIN_DIR, current_dir);
        delay_us(10);
        last_dir = current_dir;
    }
    
    ioport_set_pin_level(PIN_STEP, 1);
    delay_us(10);
    ioport_set_pin_level(PIN_STEP, 0);
    delay_us(10);
    
    return;
}

void multi_step(bool dir, uint16_t steps, uint16_t us_per_step){
    current_dir = dir;
    step_counter = 0;
    
    TCCR1A = 0b00000000; // Disable compare
    TCCR1C = 0b00000000; // Disable force output compare
    
    OCR1A = ceil(us_per_step/TC1_TICK_US);
    TCCR1B |= (1 << WGM12); // CTC mode
    
    TIMSK1 |= (1 << OCIE1A); // Enable interrupt
    TCNT1 = 0;
    TCCR1B |= TC1_DIV; // Start Timer
    
    while (step_counter < steps); // wait until all steps done
    
    // stop timer
    
    TIMSK1 &= ~(1 << OCIE1A);
    TCCR1B &= ~(0b00000111);
}

int main(void){
	
	board_init();
	ioport_init();
    cpu_irq_enable(); // enable interrupts
    
	delay_ms(500);
	
    while (1) {
        multi_step(1, 40, 2000);
        multi_step(0, 40, 2000);
    }
}

ISR(TIMER1_COMPA_vect){
    single_step();
    step_counter++;
}