//
//  eis_misc.h
//  dstat-firmware
//
//  Created by Michael Dryden on 2017-03-02.
//  Copyright © 2017 Michael Dryden. All rights reserved.
//

#ifndef eis_misc_h
#define eis_misc_h

#include <stdio.h>

#define EIS_IV_GAIN_0       0
#define EIS_IV_GAIN_100     1
#define EIS_IV_GAIN_3k      2
#define EIS_IV_GAIN_30k     3
#define EIS_IV_GAIN_300k    4
#define EIS_IV_GAIN_3M      5
#define EIS_IV_GAIN_30M     6
#define EIS_IV_GAIN_100M    7

#define EIS_REF_CELL        0
#define EIS_REF_R1          1
#define EIS_REF_R2          2
#define EIS_REF_PARALLEL    3

#define EIS_MCLK_INT        16776000UL

void eis_set_gain(uint8_t gain);
void eis_set_ref(uint8_t ref);
void eis_set_mclk(uint16_t div_2);

#endif /* eis_misc_h */
