/*
 * main.c
 *
 * Created: 29/09/2012 2:13:52 AM
 *  Author: mdryden
 */ 

#include "main.h"

//Internal global variables
int16_t p1, p2, p3, p4;
uint16_t u1;
uint8_t p5, o1, o2, o3;
uint16_t step_dac[50], step_seconds[50];

//Internal function declarations
int8_t command_handler(char command);

int8_t command_handler(char command){
	switch (command){
	case 'A': //ADS Buffer/rate/PGA
		scanf("%1X%2X%1X",&o1,&o2,&o3);
		//Sanity check goes here
		ads1255_setup(o1, o2, o3);
		break;
	case 'G': //Gain - start gain, autogain on/off, (min gain, max gain), low/high switch thresholds
		//scanf("%1u%1u%7li%7li",&g_gain,&autogain_enable,&overcurrent_threshold,&undercurrent_threshold);
		scanf("%1u",&g_gain);
		pot_set_gain();
		break;
	case 'L': //LSV - start, stop, slope
		scanf("%5i%5i%5i",&p1,&p2,&u1);
		printf("%i,%i,%i",&p1,&p2,&u1);
		lsv_experiment(p1,p2,u1,2);
		break;
	case 'C': //CV - v1, v2, start, scans, slope
		scanf("%5i%5i%5i%3i%5i",&p1,&p2,&p3,&p5,&u1);
		cv_experiment(p1,p2,p3,p5,u1);
		break;
	case 'S': //SWV
		break;
	case 'R': //CA
		break;
	default:
		printf("Ee");
		return 1;
	}
	
	printf("K");
	return 0;
}

int main(void){

	board_init();
	pot_init();
	pmic_init();
	
	irq_initialize_vectors();
	cpu_irq_enable();
	sleepmgr_init();
	sysclk_init(); //Disables ALL peripheral clocks D:
	rtc_init();
	sysclk_enable_module(SYSCLK_PORT_GEN, SYSCLK_EVSYS);
	
	pmic_set_scheduling(PMIC_SCH_ROUND_ROBIN);
	
	stdio_usb_init();
	stdio_usb_enable();
	
	ads1255_init_pins();
	ads1255_init_module();
	ads1255_setup(ADS_BUFF_ON,ADS_DR_60,ADS_PGA_2);
	pot_set_gain();
	PORTD.INT0MASK = PIN5_bm;
	PORTD.INT1MASK = PIN5_bm;
	PORTD.INTCTRL = PORT_INT0LVL_OFF_gc | PORT_INT1LVL_OFF_gc;
	
	max5443_init_pins();
	max5443_init_module();
	delay_ms(300);
	
	ads1255_wakeup();
	ads1255_rdatac();
	ads1255_standby();
	
	//Wait for application connection - Get 'c', reply 'K', get 'k'
	while(1){
		while(getchar() != 'c');
		putchar('#');
		if (getchar() == 'k')
			break;
		printf("\n\r");
	}	

//  sine wave test	
// 	#define DAC_PER_4 2
// 	
// 	uint16_t i;
// 	uint16_t delta[DAC_PER_4];
// 	
// 	for (i=0; i<DAC_PER_4; i++)
// 	{
// 		delta[i]=(sin(M_PI_2*(float)(i/(float)DAC_PER_4))*32768);
// 	}
// 	while (1){
// 		for (i = 0; i < DAC_PER_4; i++)
// 		{
// 			max5443_set_voltage1(32768+delta[i]);
// 			//printf("%u \r\n",delta[i]);
// 		}
// 		
// 		for (i = DAC_PER_4-1; i > 0; i--)
// 		{
// 			max5443_set_voltage1(32768+delta[i]);
// 			//printf("%u \r\n",delta[i]);
// 		}
// 		for (i = 0; i < DAC_PER_4; i++)
// 		{
// 			max5443_set_voltage1(32768-delta[i]);
// 			//printf("%u \r\n",delta[i]);
// 		}
// 		
// 		for (i = DAC_PER_4-1; i > 0; i--)
// 		{
// 			max5443_set_voltage1(32768-delta[i]);
// 			//printf("%u \r\n",delta[i]);
// 		}
// 	}
	
	
	while (1){
		command_handler((char)getchar());
//		lsv_experiment(0,1000,100,2);
	}
}	