/*
 * experiment.h
 *
 * Created: 01/10/2012 10:59:59 PM
 *  Author: mdryden
 */ 


#ifndef EXPERIMENT_H_
#define EXPERIMENT_H_

#include "conf_experiment.h"

#include "ads1255.h"
#include "max5443.h"
#include <tc.h>
#include <rtc.h>
#include <stdint.h>
#include <compiler.h>
#include <math.h>
#include <ioport.h>
#include <delay.h>
#include <stdio_usb.h>

#define POT_GAIN_100 0
#define POT_GAIN_300 1
#define POT_GAIN_3k 2
#define POT_GAIN_30k 3
#define POT_GAIN_300k 4
#define POT_GAIN_3M 5
#define POT_GAIN_30M 6
#define POT_GAIN_500M 7

#define POT_LP_OFF 0
#define POT_LP_ON 1

#define ADS_F_2_5 0
#define ADS_F_5 1
#define ADS_F_10 2
#define ADS_F_15 3
#define ADS_F_25 4
#define ADS_F_30 5
#define ADS_F_50 6
#define ADS_F_60 7
#define ADS_F_100 8
#define ADS_F_500 9
#define ADS_F_1000 10
#define ADS_F_2000 11
#define ADS_F_3750 12
#define ADS_F_7500 13
#define ADS_F_15000 14
#define ADS_F_30000 15

#define SIN_IMP_CYCLEPTS 50

extern uint16_t g_gain;
extern uint8_t autogain_enable;

void send_data_uint16(uint16_t data);
void send_data_int32(int32_t data);
void pot_init(void);
int8_t autogainswitch(void);
void pot_set_gain(void);
void pot_exp_start(void);
void pot_exp_stop(void);
void cv_experiment(int16_t v1, int16_t v2, int16_t start, uint8_t scans, uint16_t slope);
uint8_t lsv_experiment(int16_t start, int16_t stop, uint16_t slope, int8_t first_run);
void ca_experiment(uint16_t steps, uint16_t step_dac[], uint16_t step_seconds[]);
void swv_experiment(int16_t start, int16_t stop, uint16_t step, uint16_t pulse_height, uint16_t frequency);

#endif /* EXPERIMENT_H_ */