/*
 * main.c
 *
 * Created: 29/09/2012 2:13:52 AM
 *  Author: mdryden
 */ 

#include "main.h"

//Internal global variables
int16_t p1, p2, p3, p4;
uint16_t u1, u2, u3;
uint8_t p5, o1, o2, o3;

//uint16_t step_dac[50], step_seconds[50];

//Internal function declarations
int8_t command_handler(char command);

int8_t command_handler(char command){
	/**
	 * Deals with commands over USB
	 *
	 * Calls functions in 
	 * @param command Command character input.
	 */
	switch (command){
		case 'A': //ADS Buffer/rate/PGA values from ads1255.h
			scanf("%x%x%x",&o1,&o2,&o3);
			printf("#A: %x %x %x\r\n",o1,o2,o3);
			ads1255_setup(o1, o2, o3);
			break;
			
		case 'G': //Gain - start gain, autogain on/off, (min gain, max gain), low/high switch thresholds
			//scanf("%1u%1u%7li%7li",&g_gain,&autogain_enable,&overcurrent_threshold,&undercurrent_threshold);
			scanf("%u",&g_gain);
			printf("#G: %u\r\n", g_gain);
			pot_set_gain(); //uses global g_gain, so no params
			break;
			
		case 'L': //LSV - start, stop, slope
			scanf("%i%i%u",&p1,&p2,&u1);
			lsv_experiment(p1,p2,u1,2);
			break;
			
		case 'C': //CV - v1, v2, start, scans, slope
			scanf("%i%i%i%u%u",&p1,&p2,&p3,&p5,&u1);
			cv_experiment(p1,p2,p3,p5,u1);
			break;
			
		case 'S': //SWV - start, stop, step size, pulse_height, frequency
			scanf("%i%i%u%u%u",&p1,&p2,&u1,&u2,&u3);
			swv_experiment(p1,p2,u1,u2,u3);
			break;
			
		case 'R': //CA - steps, step_dac[], step_seconds[]
			scanf("%u",&p5); //get number of steps
			printf("#Steps: %u\n\r", p5);
			
			//allocate arrays for steps
			uint16_t * step_dac = malloc(p5*sizeof(uint16_t));
			uint16_t * step_seconds = malloc(p5*sizeof(uint16_t));
			//check for successful allocation
			if (!step_dac || !step_seconds){ 
				printf("#ERR: Could not allocate memory\n\r");
				break;
			}
			
			uint8_t i;
			
			for (i=0; i<p5; i++){
				scanf("%u", &step_dac[i]); // get voltage steps (dac units)
				printf("#DAC: %u\n\r", step_dac[i]);
			}
			
			for (i=0; i<p5; i++){
				scanf("%u", &step_seconds[i]); //get step durations (seconds)
				printf("#Time: %u\n\r", step_seconds[i]);
			}
			
			ca_experiment(p5, step_dac, step_seconds);
			
			//free arrays
			free(step_dac);
			free(step_seconds);
			
			break;
		default:
			printf("#ERR: Command %c not recognized\n\r", command);
			return 1;
	}
	printf("no\n\r");
	return 0;
}

int main(void){
	
	board_init();
	pot_init();
	pmic_init();
	
	irq_initialize_vectors();
	cpu_irq_enable();
	sleepmgr_init();
	sysclk_init(); //Disables ALL peripheral clocks D:
	rtc_init();
	sysclk_enable_module(SYSCLK_PORT_GEN, SYSCLK_EVSYS);
	
	pmic_set_scheduling(PMIC_SCH_ROUND_ROBIN);
	
	stdio_usb_init();
	stdio_usb_enable();
	
	ads1255_init_pins();
	ads1255_init_module();
	ads1255_setup(ADS_BUFF_ON,ADS_DR_60,ADS_PGA_2);

	PORTD.INT0MASK = PIN5_bm;
	PORTD.INT1MASK = PIN5_bm;
	PORTD.INTCTRL = PORT_INT0LVL_OFF_gc | PORT_INT1LVL_OFF_gc;
	
	max5443_init_pins();
	max5443_init_module();
	delay_ms(300);
	
	ads1255_wakeup();
	ads1255_rdatac();
	ads1255_standby();
	
	//Wait for application connection - Get 'c', reply 'K', get 'k'
	while(1){
		while(getchar() != 'c');
		putchar('#');
		if (getchar() == 'k')
			break;
		printf("\n\r");
	}	
	
	ads1255_setup(ADS_BUFF_ON,ADS_DR_60,ADS_PGA_2);
	
	autogain_enable = 0;
	g_gain = POT_GAIN_30k;
	pot_set_gain();
	
	program_loop:
		while(getchar() != '!');
		printf ("C\r\n");
		command_handler(getchar());
	goto program_loop;
}