/*
 * max5443.c
 *
 * Created: 06/04/2012 7:29:47 PM
 *  Author: mdryden
 */ 

#include <max5443.h>
#include <stdint.h>
#include <usart_spi.h>
#include <compiler.h>
#include <ioport.h>
#include <delay.h>
#include <stdio_usb.h>

// From module: NVM - Non Volatile Memory
#include <nvm.h>

// From module: NVM - Non volatile memory access
#include <common_nvm.h>

#define MAX5443_EEPROM_PARAM_PAGE 1
#define MAX5443_EEPROM_OFFSET_ADDR MAX5443_EEPROM_PARAM_PAGE * EEPROM_PAGE_SIZE

volatile int16_t max5443_offset = 0;

struct usart_spi_device spi_device_conf_c = {
          .id = IOPORT_CREATE_PIN(PORTC, 4)
      };

void max5443_init_pins(void){
	arch_ioport_set_port_dir(IOPORT_PORTC, PIN4_bm|PIN5_bm|PIN7_bm, IOPORT_DIR_OUTPUT);
	arch_ioport_set_port_level(IOPORT_PORTC, PIN4_bm|PIN5_bm|PIN7_bm, PIN4_bm|PIN5_bm|PIN7_bm);
}

void max5443_init_module(void){
	usart_spi_init(&USARTC1);
	usart_spi_setup_device(&USARTC1, &spi_device_conf_c, SPI_MODE_0, 24000000UL, 0);
	max5443_read_eeprom();
}

void max5443_read_eeprom(void){
	max5443_offset = nvm_eeprom_read_byte(MAX5443_EEPROM_OFFSET_ADDR);
	printf("#OFFSET = %u\n\r", max5443_offset);
}

void max5443_write_eeprom(void){
	nvm_eeprom_load_byte_to_buffer(0x0, max5443_offset);
	nvm_eeprom_atomic_write_page(MAX5443_EEPROM_PARAM_PAGE * EEPROM_PAGE_SIZE);
}

void max5443_set_voltage1(uint16_t dacindex){
	static union{
		uint8_t ui8[2];
		uint16_t ui16;
	} buffer;
		
// 	if (buffer.ui16 == dacindex)
// 		return;
	if (max5443_offset < 0)
	{
		max5443_offset = abs(max5443_offset);
		if (((uint16_t)max5443_offset) > dacindex)
			buffer.ui16 = 0;
		else
			buffer.ui16 = dacindex - (uint16_t)max5443_offset;
	}
	else if (((uint16_t)max5443_offset) > (65535 - dacindex))
		buffer.ui16 = 65535;
	else
		buffer.ui16 = dacindex + (uint16_t)max5443_offset;
	
	
// 	if (65535-dacindex < max5443_offset)
// 		buffer.ui16 = 65535;
// 	else if (dacindex < (uint16_t)(-1*max5443_offset))
// 		buffer.ui16 = 0;
// 	else
// 		buffer.ui16 = dacindex+max5443_offset;
	
 	irqflags_t flags;
    flags = cpu_irq_save();

	usart_spi_select_device(&USARTC1, &spi_device_conf_c);
	usart_spi_write_single(&USARTC1, buffer.ui8[1]);
	delay_cycles(40);
	usart_spi_write_single(&USARTC1, buffer.ui8[0]);
	usart_spi_deselect_device(&USARTC1, &spi_device_conf_c);
	
	cpu_irq_restore(flags);
	
	return;
}

// void max5443_set_voltage_8bit(uint8_t dacindex){
// 	spi_select_device(&SPIC, &spi_device_conf_c);
// 	spi_write_single(&SPIC, dacindex);
// 	spi_deselect_device(&SPIC, &spi_device_conf_c);
// 	return;
// }

/*void max5443_set_voltage(uint8_t msb, uint8_t lsb){
	irqflags_t flags;
    flags = cpu_irq_save();
	
	spi_select_device(&SPIC, &spi_device_conf_c);
	spi_write_single(&SPIC, msb);
	spi_write_single(&SPIC, lsb);
	spi_deselect_device(&SPIC, &spi_device_conf_c);
	
	cpu_irq_restore(flags);
}*/