/*
 * experiment.c
 *
 * Created: 01/10/2012 10:59:48 PM
 *  Author: mdryden
 */ 

#include "experiment.h"

//Private variables
volatile int32_t voltage = 0;
volatile uint16_t dacindex = 0;
uint16_t dacindex_stop = 0;
volatile int8_t up = 1;
volatile uint16_t iter = 0;
uint16_t* eis_ptr = 0;
volatile uint16_t cycles = 0;
volatile uint16_t samples = 0;
volatile uint16_t tcf0period = 0;
uint32_t skip_samples = 0;

//Private function declarations
static void porte_int0_lsv(void);
static void tcf0_ovf_callback(void);
static void tce1_ovf_callback_lsv(void);
static void lsv_cca_callback(void);

//interrupt callback setup
typedef void (*port_callback_t) (void);

static port_callback_t portd_int0_callback;
static port_callback_t portd_int1_callback;

void pot_init(void){
	arch_ioport_set_port_dir(IOPORT_PORTB, PIN3_bm|PIN4_bm|PIN5_bm|PIN6_bm|PIN7_bm, IOPORT_DIR_OUTPUT);
	arch_ioport_set_port_dir(IOPORT_PORTD, PIN4_bm, IOPORT_DIR_OUTPUT);
	arch_ioport_set_port_level(IOPORT_PORTB, PIN3_bm|PIN4_bm|PIN5_bm|PIN6_bm|PIN7_bm, PIN6_bm|PIN7_bm);
	arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, PIN4_bm);
}

int8_t autogainswitch(void){
	extern int8_t over_under[ADS_OVER_UNDER_SAMPLES]; //from ads1255.h
	int8_t overcurrent = 0;
	static uint8_t hysteresis = 0;
	static uint8_t last_return = 0;
	
	if (gain == POT_GAIN_500M)
		return 0;
	
	if (last_return==1)
	{
		last_return=0;
		return 1;
	}
	
	if (hysteresis < ADS_OVER_UNDER_SAMPLES-1){
		++hysteresis;
		return 0;
	}
	
	for (uint16_t i = 0; i < ADS_OVER_UNDER_SAMPLES; ++i)
		overcurrent += over_under[i];
	
	if (overcurrent == ADS_OVER_UNDER_SAMPLES && gain > POT_GAIN_300)
	{	
		--gain;
		pot_set_gain();
		last_return=1;
		hysteresis = 0;
		for (uint16_t i = 0; i < ADS_OVER_UNDER_SAMPLES; ++i)
		over_under[i]=0;
		
		return 1;
	}
	
	if ((overcurrent*-1) == (ADS_OVER_UNDER_SAMPLES) && gain < POT_GAIN_30M)
	{
		if (hysteresis < ADS_OVER_UNDER_SAMPLES+3){
			++hysteresis;
			return 0;
		}
		
		++gain;
		pot_set_gain();
		last_return=1;
		hysteresis = 0;
		for (uint16_t i = 0; i < ADS_OVER_UNDER_SAMPLES; ++i)
		over_under[i]=0;
		
		return 1;
	}
	hysteresis = 0;
	return 0;
}

void pot_set_gain(void){
	switch (gain){
		case POT_GAIN_500M:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT); //A
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT); //B
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT); //C
		
		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, 0);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, 0);
		
		printf("INFO: 500M\n\r");
		break;
		
		case POT_GAIN_30M:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
		
		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN6_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, 0);
		printf("INFO: 30M\n\r");
		break;
		
		case POT_GAIN_3M:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
		
		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN7_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, 0);
		printf("INFO: 3M\n\r");
		break;
		
		case POT_GAIN_300k:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
		
		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN6_bm|PIN7_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, 0);
		printf("INFO: 300k\n\r");
		break;
		
		case POT_GAIN_30k:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
		
		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, 0);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, PIN4_bm);
		printf("INFO: 30k\n\r");
		break;
		
		case POT_GAIN_3k:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);

		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN6_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, PIN4_bm);
		printf("INFO: 3k\n\r");
		break;
		
		case POT_GAIN_300:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);

		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN7_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, PIN4_bm);
		printf("INFO: 300\n\r");
		break;
		
		case POT_GAIN_100:
// 		ioport_configure_port_pin(&PORTB, PIN6_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTB, PIN7_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 		ioport_configure_port_pin(&PORTD, PIN4_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);

		arch_ioport_set_port_level(IOPORT_PORTB, PIN6_bm|PIN7_bm, PIN6_bm|PIN7_bm);
		arch_ioport_set_port_level(IOPORT_PORTD, PIN4_bm, PIN4_bm);
		printf("INFO: 100\n\r");
		break;
		
		default:
		printf("WAR: Invalid pot gain.\n\r");
		break;
		
		return;
	}
}

void pot_exp_start(void){
// 	ioport_configure_port_pin(&PORTB, PIN3_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 	ioport_configure_port_pin(&PORTB, PIN4_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
// 	ioport_configure_port_pin(&PORTB, PIN5_bm, IOPORT_INIT_HIGH | IOPORT_DIR_OUTPUT);
	
	arch_ioport_set_port_level(IOPORT_PORTB, PIN3_bm|PIN4_bm|PIN5_bm, PIN3_bm|PIN4_bm|PIN5_bm);
}

void pot_exp_stop(void){
// 	ioport_configure_port_pin(&PORTB, PIN3_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 	ioport_configure_port_pin(&PORTB, PIN4_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
// 	ioport_configure_port_pin(&PORTB, PIN5_bm, IOPORT_INIT_LOW | IOPORT_DIR_OUTPUT);
	
	arch_ioport_set_port_level(IOPORT_PORTB, PIN3_bm|PIN4_bm|PIN5_bm, 0);
}

void cv_experiment(int16_t v1, int16_t v2, int16_t start, uint8_t scans, uint16_t slope){
	// check if start is [v1,v2]
	int8_t firstrun = 1;
	
	if((start < v1 && start < v2) || (start > v1 && start > v2))
	{
		printf("ERR: Start must be within [v1, v2]\n\r");
		return;
	}
	
	RTC.CTRL = RTC_PRESCALER_OFF_gc;
	while (RTC.STATUS & RTC_SYNCBUSY_bm);
	RTC.CNT = 0;
	RTC.PER = 0xffff;
	RTC.CTRL = RTC_PRESCALER_DIV1024_gc; // 1 s tick
	
	
	while(scans > 0){
		if (start != v1){
			lsv_experiment(start,v1,slope,firstrun);
			firstrun = 0;
		}
		if (start == v2 && scans == 1)
			firstrun = -1;
		lsv_experiment(v1,v2,slope,firstrun);
		if (scans == 1)
			firstrun = -1;
		if (start != v2)
			lsv_experiment(v2,start,slope,firstrun);
		--scans;
		firstrun = 0;
	}
	
	printf("Time: %lu s \n\r", rtc_get_time());
	
	return;
}

void lsv_experiment(int16_t start, int16_t stop, uint16_t slope, int8_t first_run){
	//check experiment limits
	if(start<-1500 || start>1500 ||start==stop|| stop<-1500 || stop>1500 || slope>7000)
	{
		printf("ERR: Experiment parameters outside limits\n\r");
		return;
	}
	
	uint16_t dacindex_start = ceil(start*(65535/(double)3000)+32767);
	dacindex_stop = ceil(stop*(65535/(double)3000)+32767);
	//	uint16_t period;
	uint32_t timer_period;
	uint16_t temp_div;

	max5443_set_voltage1(dacindex_start);
	
	if (first_run == 1 || first_run == 2){
		pot_exp_start();
		ads1255_rdatac();
		tc_enable(&TCC1);
		
		ads1255_sync();

		tc_enable(&TCC0);
		tc_set_overflow_interrupt_callback(&TCC0, tcf0_ovf_callback);
		tc_set_overflow_interrupt_callback(&TCC1, tce1_ovf_callback_lsv);
		tc_set_cca_interrupt_callback(&TCC1, lsv_cca_callback);
		portd_int0_callback = porte_int0_lsv;

		//set EVCH0 event
		EVSYS.CH0MUX = EVSYS_CHMUX_TCC0_OVF_gc;
		EVSYS.CH0CTRL = 0;

		timer_period = ceil(1/((double)slope/(3000./65535))*(F_CPU));
		temp_div = ceil(timer_period/65535.);
		
		if (temp_div <= 1)
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV1_gc);
		else if (temp_div == 2){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV2_gc);
			timer_period /= 2;
		}
		else if (temp_div <= 4){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV4_gc);
			timer_period /= 4;
		}
		else if (temp_div <= 8){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV8_gc);
			timer_period /= 8;
		}
		else if (temp_div <= 64){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV64_gc);
			timer_period /= 64;
		}
		else if (temp_div <= 256){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV256_gc);
			timer_period /= 256;
		}
		else if (temp_div <= 1024){
			tc_write_clock_source(&TCC0,TC_CLKSEL_DIV1024_gc);
			timer_period /= 1024;
		}
		else{
			printf("ERR: Frequency/ADC rate is too low\n\r");
			return;
		}
		
		printf("Period:%lu\n\r", timer_period);
		ads1255_wakeup();
		tc_write_period(&TCC1, 0xffff);
		tc_write_period(&TCC0, (uint16_t)timer_period);
	}
	
	TCC1.CNT = dacindex_start;
	
	if (stop > start)
	{
		up = 1;
		tc_set_direction(&TCC1, TC_UP);
	}
	else
	{
		up = -1;
		tc_set_direction(&TCC1, TC_DOWN);
	}
	
	tc_write_cc(&TCC1, TC_CCA, dacindex_stop);
	tc_enable_cc_channels(&TCC1, TC_CCAEN);
	TCC0.CNT = 0;
	
	tc_set_cca_interrupt_level(&TCC1, TC_INT_LVL_HI);
	tc_set_overflow_interrupt_level(&TCC0, TC_OVFINTLVL_MED_gc);
	PORTD.INTCTRL = PORT_INT0LVL_LO_gc;
	
	tc_write_clock_source(&TCC1, TC_CLKSEL_EVCH0_gc);
	
	while (up != 0); //Experiment run with interrupts
	
	if (first_run == -1 || first_run == 2)
	{
		tc_disable(&TCC0);
		TCC0.CNT = 0x0;
		tc_disable(&TCC1);
		pot_exp_stop();
		ads1255_standby();
	}
	
	return;
}

static void porte_int0_lsv(void){
	if (autogainswitch()==0){
//		while (ioport_pin_is_high(IOPORT_CREATE_PIN(PORTD, 5)));
		while (arch_ioport_get_pin_level(IOPORT_CREATE_PIN(PORTD, 5)));
		if (gain == POT_GAIN_300)
		printf("%u, %ld00000\n\r", TCC1.CNT, ads1255_read());
		else if (gain == POT_GAIN_3k)
		printf("%u, %ld0000\n\r", TCC1.CNT, ads1255_read());
		else if (gain == POT_GAIN_30k)
		printf("%u, %ld000\n\r", TCC1.CNT, ads1255_read());
		else if (gain == POT_GAIN_300k)
		printf("%u, %ld00\n\r", TCC1.CNT, ads1255_read());
		else if (gain == POT_GAIN_3M)
		printf("%u, %ld0\n\r", TCC1.CNT, ads1255_read());
		else if (gain == POT_GAIN_30M)
		printf("%u, %ld\n\r", TCC1.CNT, ads1255_read());
		else
		printf("%u, %lu\n\r", TCC1.CNT, ads1255_read());
	}
	else{
//		while (ioport_pin_is_high(IOPORT_CREATE_PIN(PORTD, 5)));
		while (arch_ioport_get_pin_level(IOPORT_CREATE_PIN(PORTD, 5)));
		ads1255_read();
	}
}

static void tcf0_ovf_callback(void){
	max5443_set_voltage1(TCC1.CNT);
}

static void tce1_ovf_callback_lsv(void){
	PORTD.INTCTRL = PORT_INT0LVL_OFF_gc;
	tc_set_overflow_interrupt_level(&TCC0, TC_OVFINTLVL_OFF_gc);
	tc_set_overflow_interrupt_level(&TCC1, TC_OVFINTLVL_OFF_gc);
	up = 0;
	return;
}

static void lsv_cca_callback(void){
	PORTD.INTCTRL = PORT_INT0LVL_OFF_gc;
	tc_set_overflow_interrupt_level(&TCC0, TC_OVFINTLVL_OFF_gc);
	tc_set_cca_interrupt_level(&TCC1, TC_INT_LVL_OFF);
	up = 0;
	return;
}