/*
 * main.c
 *
 * Created: 29/09/2012 2:13:52 AM
 *  Author: mdryden
 */ 

#include "main.h"

int main(void){

	board_init();
	pot_init();
	pmic_init();
	
	irq_initialize_vectors();
	cpu_irq_enable();
	sleepmgr_init();
	sysclk_init(); //Disables ALL peripheral clocks D:
	rtc_init();
	sysclk_enable_module(SYSCLK_PORT_GEN, SYSCLK_EVSYS);
	
	pmic_set_scheduling(PMIC_SCH_ROUND_ROBIN);
	
	stdio_usb_init();
	stdio_usb_enable();
	
	ads1255_init_pins();
	ads1255_init_module();
	ads1255_setup(ADS_BUFF_ON,ADS_DR_60,ADS_PGA_2);
	PORTD.INT0MASK = PIN5_bm;
	PORTD.INT1MASK = PIN5_bm;
	PORTD.INTCTRL = PORT_INT0LVL_OFF_gc | PORT_INT1LVL_OFF_gc;
	
	max5443_init_pins();
	max5443_init_module();
	delay_ms(300);
	
	uint16_t input;
	
	// 	RTC.CTRL = RTC_PRESCALER_OFF_gc;
	// 	while (RTC.STATUS & RTC_SYNCBUSY_bm);
	// 	RTC.CNT = 0;
	// 	RTC.PER = 0xffff;
	// 	RTC.CTRL = RTC_PRESCALER_DIV1_gc;
	
	ads1255_wakeup();
	ads1255_rdatac();

	//	max5443_set_voltage1(21845); //1V
	//	pot_exp_start();
	
	while (1){
		ads1255_standby();
		
		printf("Choose Experiment type:\n\r");
		printf("Options:0, LSV:1, CV:2, SWV:3, AMP:4, EIS:5\n\r");
		printf("DStat v1.1 27 Aug 2012\n\r");
		
		scanf("%u", &input);
		
		getchar();
		
	}
}	