//
//  eis.h
//  dstat-firmware
//
//  Created by Michael Dryden on 2017-03-20.
//  Copyright © 2017 Michael Dryden. All rights reserved.
//

#ifndef eis_h
#define eis_h

#define EIS_STATUS_READY    0
#define EIS_STATUS_MEASURE  1
#define EIS_STATUS_DONE     2

#include <stdio.h>
#include "ad5933.h"

void eis_init(void);

void eis_measure_auto(uint32_t start, uint32_t increment, uint16_t n_increments,
                      uint16_t settle_cycles, uint8_t pga_gain, uint8_t output_range,
                      uint8_t iv_gain, uint16_t attenuation, uint16_t offset,
                      uint8_t reference, cint16_t* result_buffer);
void eis_set_params(uint32_t start, uint32_t increment, uint16_t n_increments,
                    uint16_t settle_cycles, uint8_t pga_gain, uint8_t output_range,
                    uint8_t iv_gain, uint16_t attenuation, uint16_t offset,
                    uint8_t reference);
cint16_t eis_measure_one(void);

extern uint8_t eis_status;

#endif /* eis_h */
