//
//  settings.c
//  dstat-firmware
//
//  Created by Michael Dryden on 2015-10-14.
//  Copyright © 2015 wheeler lab. All rights reserved.
//
//  Save/Retrieve settings from EEPROM

#include "settings.h"
#include "config/conf_board.h"

#define SETTINGS_EEPROM_PARAM_PAGE 0
#define SETTINGS_EEPROM_OFFSET_ADDR SETTINGS_EEPROM_PARAM_PAGE * EEPROM_PAGE_SIZE

void settings_handler(char command){
    switch (command){
        case 'D': //Reset defaults
            settings_restore_defaults();
            break;
            
        case 'R': //Read settings from EEPROM
            settings_read_eeprom();
            break;
            
        case 'W': //Write new settings
            scanf("%i%hhu%u", &settings.settings.max5443_offset, &settings.settings.tcs_enabled, &settings.settings.tcs_clear_threshold);
            settings_write_eeprom();
            break;
            
        default:
            printf("#ERR: Command %c not recognized\n\r", command);
    }
}

void settings_read_eeprom(void){
    printf("#INFO: SETTINGS\n\r");
    nvm_eeprom_read_buffer(SETTINGS_EEPROM_OFFSET_ADDR, &settings, EEPROM_PAGE_SIZE);
    if (settings.settings.programmed != 1) {
        printf("#INFO: EEPROM not programmed\n\r");
        settings_restore_defaults();
    }
    printf("#INFO: max5443_offset = %u\n\r", settings.settings.max5443_offset);
    printf("#INFO: tls_enabled = %u\n\r", settings.settings.tcs_enabled);
    printf("#INFO: tls_clear_threshold = %u\n\r", settings.settings.tcs_clear_threshold);
}

void settings_write_eeprom(void){
    nvm_eeprom_load_page_to_buffer(&settings);
    nvm_eeprom_atomic_write_page(SETTINGS_EEPROM_OFFSET_ADDR);
}

void settings_restore_defaults(void){
    printf("#INFO: Restoring EEPROM Defaults\n\r");
    settings.settings.programmed = 1;
    settings.settings.max5443_offset = SETTINGS_MAX5443_OFFSET;
    settings.settings.tcs_enabled = SETTINGS_TCS_ENABLED;
    settings.settings.tcs_clear_threshold = SETTINGS_TCS_CLEAR_THRESHOLD;
    
    settings_write_eeprom();
}

