/*
 * max5443.c
 *
 * Created: 06/04/2012 7:29:47 PM
 *  Author: mdryden
 */ 

#include <max5443.h>

//static uint16_t dac_samples[DMA_BUFFER_SIZE / 2];
static void dma_init(void);

struct usart_spi_device spi_device_conf_c = {
          .id = IOPORT_CREATE_PIN(PORTC, 4)
      };

void max5443_init_pins(void){
	arch_ioport_set_port_dir(IOPORT_PORTC, PIN4_bm|PIN5_bm|PIN7_bm, IOPORT_DIR_OUTPUT);
	arch_ioport_set_port_level(IOPORT_PORTC, PIN4_bm|PIN5_bm|PIN7_bm, PIN4_bm|PIN5_bm|PIN7_bm);
}

void max5443_init_module(void){
	usart_spi_init(&USARTC1);
	usart_spi_setup_device(&USARTC1, &spi_device_conf_c, SPI_MODE_0, 24000000UL, 0);
	
//	dma_init();
}

static void dma_init(void){
	struct dma_channel_config dmach_conf;
	memset(&dmach_conf, 0, sizeof(dmach_conf));

	dma_channel_set_burst_length(&dmach_conf, DMA_CH_BURSTLEN_1BYTE_gc);
	dma_channel_set_transfer_count(&dmach_conf, 1);

	dma_channel_set_src_reload_mode(&dmach_conf,DMA_CH_SRCRELOAD_BURST_gc);
	dma_channel_set_dest_reload_mode(&dmach_conf,DMA_CH_DESTRELOAD_BURST_gc);

	dma_channel_set_src_dir_mode(&dmach_conf, DMA_CH_SRCDIR_FIXED_gc);
	dma_channel_set_dest_dir_mode(&dmach_conf, DMA_CH_DESTDIR_FIXED_gc);

	dma_channel_set_source_address(&dmach_conf,(uint16_t)(uintptr_t)(&TCC1_CNT+0x01));
	dma_channel_set_destination_address(&dmach_conf,(uint16_t)(uintptr_t)&USARTC1_DATA);

	dma_channel_set_trigger_source(&dmach_conf, DMA_CH_TRIGSRC_TCC0_OVF_gc);
	dma_channel_set_single_shot(&dmach_conf);

	dma_enable();

	//dma_set_callback(DMA_CHANNEL, dma_transfer_done);
	//dma_channel_set_interrupt_level(&dmach_conf, DMA_INT_LVL_LO);

	dma_channel_write_config(DMA_CHANNEL, &dmach_conf);
	dma_channel_enable(DMA_CHANNEL);
}

void max5443_set_voltage1(uint16_t dacindex){
	static union{
		uint8_t ui8[2];
		uint16_t ui16;
	} buffer;
		
	if (buffer.ui16 == dacindex)
		return;
		
	buffer.ui16 = dacindex;
	
 	irqflags_t flags;
     flags = cpu_irq_save();

	usart_spi_select_device(&USARTC1, &spi_device_conf_c);
	usart_spi_write_single(&USARTC1, buffer.ui8[1]);
	delay_cycles(40);
	usart_spi_write_single(&USARTC1, buffer.ui8[0]);
	usart_spi_deselect_device(&USARTC1, &spi_device_conf_c);
	
	cpu_irq_restore(flags);
	return;
}

// void max5443_set_voltage_8bit(uint8_t dacindex){
// 	spi_select_device(&SPIC, &spi_device_conf_c);
// 	spi_write_single(&SPIC, dacindex);
// 	spi_deselect_device(&SPIC, &spi_device_conf_c);
// 	return;
// }

/*void max5443_set_voltage(uint8_t msb, uint8_t lsb){
	irqflags_t flags;
    flags = cpu_irq_save();
	
	spi_select_device(&SPIC, &spi_device_conf_c);
	spi_write_single(&SPIC, msb);
	spi_write_single(&SPIC, lsb);
	spi_deselect_device(&SPIC, &spi_device_conf_c);
	
	cpu_irq_restore(flags);
}*/