//
//  ad5933.h
//  dstat-firmware
//
//  Created by Marc Goudge on 2016-12-18.
//  Note: the library for AD5933 communications is largely based on the C++ library written
//  by Michael Meli for Arduino. Adaptations have been made such that this library is compatible
//  with the ATXmega256a3u.

#ifndef ad5933_h
#define ad5933_h

#include <math.h>
#include <stdio.h>

#define AD5933_MEASURE_FIRST    0
#define AD5933_MEASURE_REPEAT   1
#define AD5933_MEASURE_NEXT     2

typedef struct c_int16_t {
    int16_t real;
    int16_t imag;
} cint16_t;

void ad5933_set_params(uint32_t start, uint32_t increment, uint16_t n_increments,
                        uint16_t settle_cycles, uint8_t gain);
void ad5933_sweep(cint16_t imp[], int n);
cint16_t ad5993_get_complex_data(void);
cint16_t ad5933_measure_one(uint8_t measure_type);

void ad5933_test(void);

#endif /* ad5933_h */
