/**
 * \file
 *
 * \brief Empty user application template
 *
 */

/*
 * Include header files for all drivers that have been imported from
 * Atmel Software Framework (ASF).
 */
#include <asf.h>
#include <string.h>
#include <ads1255.h>

static bool main_b_vbus_event = false;
static bool main_b_resume_event = false;
static bool main_b_suspend_event = false;
static bool main_b_sof_event = false;
static bool main_b_cdc_configurated = false;
static bool main_b_cdc_enumerated = false;


void usblog(char logdata[], int length){
	for (int i = 0; i<length; i++)
	{
		stdio_usb_putchar(&USARTD1,(int)(logdata[i]));
	}
	
	stdio_usb_putchar(&USARTD1, '\n');
	stdio_usb_putchar(&USARTD1, '\r');
}


void main_vbus_action(bool b_high)
{
	if (b_high) {
		main_b_vbus_event = true;
		// Attach USB Device
		udc_attach();
	} else {
		// VBUS not present
		udc_detach();
	}
}

void main_suspend_action(void)
{
	main_b_resume_event = true;
}

void main_resume_action(void)
{
	main_b_suspend_event = true;
}

void main_sof_action(void)
{
	main_b_sof_event = true;
}

void main_remotewakeup_enable(void)
{
}

void main_remotewakeup_disable(void)
{
}

bool main_cdc_enable(void)
{
	main_b_cdc_enumerated = true;
	return true;
}

void main_cdc_disable(void)
{
	main_b_cdc_enumerated = false;
}

void main_cdc_config(void)
{
	main_b_cdc_configurated = true;
}
int main (void)
{
	//board_init();
	
	
	//pll_enable_config_defaults(0);
	//osc_enable(OSC_ID_XOSC);
	//osc_wait_ready(OSC_ID_XOSC);
	//osc_enable(OSC_ID_RC32KHZ);
	//osc_wait_ready(OSC_ID_RC32KHZ);
	
	//irq_initialize_vectors();
	//cpu_irq_enable();
	//sleepmgr_init();
	//sysclk_init();
	//sysclk_enable_usb(48);
	
	
	//rtc_init();

	
	//udc_start();
	
	sysclk_init();
	irq_initialize_vectors();
	cpu_irq_enable();

	// Initialize the sleep manager
	sleepmgr_init();
	//udc_start();
	
	stdio_usb_init(&USARTD1);

	if (!udc_include_vbus_monitoring()) {
		// VBUS monitoring is not available on this product
		// thereby VBUS has to be considered as present
		main_vbus_action(true);
	}
	//udc_attach

	// The main loop manages only the power mode
	// because the USB management is done by interrupt
	while (!main_b_cdc_configurated) {
		//sleepmgr_enter_sleep();
		// No test_assert_true() call
		// because it must be a timeout from server
	}
	while (!main_b_cdc_enumerated);
	
	
	stdio_usb_enable();

	char logstr[50];
	
	ads1255_init_pins();

	ads1255_init_module();
	
	ads1255_reset();
	
	uint32_t z[10];
	uint8_t input_buffer[11];
	
	
	while(1){
		//ads1255_read();
		//delay_ms(100);
		ads1255_reset();
		sprintf(logstr, "%li", ads1255_read());
		usblog(logstr, strlen(logstr));
		stdio_usb_getchar(&USARTD1,(int*)0);
		ads1255_reg_read(0x0,input_buffer);
		
		for (int i=0; i<10; i++)
		{
			sprintf(logstr, "%i", i);
			usblog(logstr, strlen(logstr));
			z[i]=0;
		while (ioport_pin_is_high(IOPORT_CREATE_PIN(PORTE, 3)));
		while (ioport_pin_is_low(IOPORT_CREATE_PIN(PORTE, 3)))
			{z[i]++;}
		}		
		
		for (int i = 1; i<10; i++)
		{
			z[0] = z[0]+z[i];
		}
		
		z[0] = z[0]/10;
		
		sprintf(logstr, "Period: %li", z[0]);
		usblog(logstr, strlen(logstr));
		
		stdio_usb_getchar(&USARTD1,(int*)0);
		
		ads1255_setup(ADS_DR_2_5, ADS_PGA_2);
		ads1255_reg_read(0x0, input_buffer);
		
		for (int i=0; i<10; i++)
		{
			z[i]=0;
		while (ioport_pin_is_high(IOPORT_CREATE_PIN(PORTE, 3)));
		while (ioport_pin_is_low(IOPORT_CREATE_PIN(PORTE, 3)))
			{z[i]++;}
		}		
		
		for (int i = 1; i<10; i++)
		{
			z[0] = z[0]+z[i];
		}
		
		z[0] = z[0]/10;
		
		sprintf(logstr, "Period: %li", z[0]);
		usblog(logstr, strlen(logstr));
	
		
	}
	

	// Insert application code here, after the board has been initialized.
}
