//
//  eis_misc.c
//  dstat-firmware
//
//  Created by Michael Dryden on 2017-03-02.
//  Copyright © 2017 Michael Dryden. All rights reserved.
//

#include "eis_misc.h"
#include "ds4550.h"
#include <delay.h>

void eis_set_gain(uint8_t gain){
    /**
     * Set EIS IV converter gain.
     *
     * @param gain Gain setting defined in eis_misc.h
     */
    
    delay_ms(30);
    switch (gain) {
        case EIS_IV_GAIN_0:
            ds4550_set_pins(0b110000110, 0b111000000);
            printf("#INFO: EIS gain 0\r\n");
            break;
        case EIS_IV_GAIN_100:
            ds4550_set_pins(0b111000110, 0b111000000);
            printf("#INFO: EIS gain 100\r\n");
            break;
        case EIS_IV_GAIN_3k:
            ds4550_set_pins(0b101000110, 0b111000000);
            printf("#INFO: EIS gain 3k\r\n");
            break;
        case EIS_IV_GAIN_30k:
            ds4550_set_pins(0b100000110, 0b111000000);
            printf("#INFO: EIS gain 30k\r\n");
            break;
        case EIS_IV_GAIN_300k:
            ds4550_set_pins(0b011000110, 0b111000000);
            printf("#INFO: EIS gain 300k\r\n");
            break;
        case EIS_IV_GAIN_3M:
            ds4550_set_pins(0b010000110, 0b111000000);
            printf("#INFO: EIS gain 3M\r\n");
            break;
        case EIS_IV_GAIN_30M:
            ds4550_set_pins(0b001000110, 0b111000000);
            printf("#INFO: EIS gain 30M\r\n");
            break;
        case EIS_IV_GAIN_100M:
            ds4550_set_pins(0b000000110, 0b111000000);
            printf("#INFO: EIS gain 100M\r\n");
            break;
        default:
            printf("#WAR: EIS: No gain provided\r\n");
            break;
    }
    
    return;
}

void eis_set_ref(uint8_t ref){
    /**
     * Set EIS reference resistor switches.
     *
     * @param ref Reference setting defined in eis_misc.h
     */
    
    delay_ms(30);
    switch (ref) {
        case EIS_REF_CELL:
            ds4550_set_pins(0b000000000, 0b000110000);
            printf("#INFO: EIS REF RE\r\n");
            break;
        case EIS_REF_R1:
            ds4550_set_pins(0b000010000, 0b000110000);
            printf("#INFO: EIS REF R1\r\n");
            break;
        case EIS_REF_R2:
            ds4550_set_pins(0b000100000, 0b000110000);
            printf("#INFO: EIS REF R2\r\n");
            break;
        case EIS_REF_PARALLEL:
            ds4550_set_pins(0b000110000, 0b000110000);
            printf("#INFO: EIS REF R1+2\r\n");
            break;
            
        default:
            printf("#WAR: EIS: No reference set.\r\n");
            break;
    }

    return;
}

