from __future__ import annotations
from typing import Union, TYPE_CHECKING

from dstat_interface.utils import Singleton

if TYPE_CHECKING:
    from pkg_resources._vendor.packaging import version
    from dstat_interface.dstat.comm import SerialConnection
    from dstat_interface.dstat.boards import BaseBoard


class DStatState(object, metaclass=Singleton):
    def __init__(self):
        self.settings = {}
        self.ser: Union[None, SerialConnection] = None
        self.dstat_version: Union[None, version.Version] = None
        self.firmware_version: Union[None, str] = None
        self.board_instance: Union[None, BaseBoard] = None

    def reset(self):
        self.settings = {}
        self.ser = None
        self.dstat_version = None
        self.firmware_version = None
        self.board_instance = None
