import pytest
from pkg_resources import parse_version

from dstat_interface.dstat.comm import dstat_connect, read_settings, write_settings
from dstat_interface.dstat import simulator, state


class TestDStat:
    @pytest.yield_fixture(autouse=True)
    def dstat_connect_simulator(self):
        dstat_connect('simulator')
        yield
        state.ser.close()

    def test_dstat_connect(self):
        assert state.dstat_version == parse_version('1.2.3') and state.firmware_version == 'fffffff'

    def test_read_settings(self):
        read_settings()
        assert state.settings == simulator.Simulator.default_settings

    def test_write_settings(self):
        new_settings = dict([('max5443_offset', 200),
                             ('tcs_enabled', 0),
                             ('tcs_clear_threshold', 19000),
                             ('r100_trim', 23),
                             ('r3k_trim', 14),
                             ('r30k_trim', 56),
                             ('r300k_trim', 3),
                             ('r3M_trim', 2),
                             ('r30M_trim', -34),
                             ('r100M_trim', -60)
                             ('eis_cal1', 0),
                             ('eis_cal2', 0),
                             ('dac_units_true', 1)
                             ])
        state.settings = new_settings
        write_settings()
        state.settings = {}
        read_settings()
        assert state.settings == new_settings
