import os
import sys
from pathlib import Path


class Singleton(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super(Singleton, cls).__call__(*args, **kwargs)
        return cls._instances[cls]


def runtime_dir():
    """Get the runtime directory where we can create named pipes"""
    if sys.platform.startswith('linux'):
        return os.environ['XDG_RUNTIME_DIR']
    elif sys.platform == 'darwin':
        return '/private/var/tmp'
    elif sys.platform == 'win32':
        # Windows uses named pipes which aren't part of the normal filesystem
        return ''
    else:
        raise NotImplementedError('Where do I create named pipes on this platform?')
